#pragma once

#include <unordered_map>
#include <boost/optional.hpp>
#include <internal/shard.h>
#include <internal/guarded.h>

namespace sharpei {
namespace cache {

class StateCache {
public:
    using State = Shard::Database::State;
    using OptState = boost::optional<State>;
    using Address = Shard::Database::Address;
    using HostsWithOptState = std::map<Address, OptState>;
    using Hosts = std::map<Address, State>;
    using Shards = std::unordered_map<Shard::Id, Hosts>;

    StateCache& operator =(const StateCache& other);

    OptState get(Shard::Id shardId, const Address& address) const;
    void update(Shard::Id shardId, const HostsWithOptState& hosts);
    void erase(Shard::Id shardId);

private:
    static constexpr Shard::Database::State::ReplicationLag maxLag =
            std::numeric_limits<Shard::Database::State::ReplicationLag>::max();

    guarded<Shards, std::shared_mutex> shards;

    static Hosts makeNewHosts(const Hosts& oldHosts, const HostsWithOptState& updatedHosts);
};

} // namespace cache
} // namespace sharpei
