#pragma once

#include <internal/poller/poller.h>
#include <internal/cloud/cluster_shards_provider.h>
#include <internal/cloud/cluster_poller_config.h>

namespace sharpei::cloud {

class ClusterPoller {
public:
    ClusterPoller(const ClusterPollerConfig& config, const db::ShardConfig& shardConfig,
            db::ShardPoolPtr shardPool, YcHostsCachePtr hostsCache, cache::CachePtr cache) {
        std::string uniqId = "cluster_poller";
        boost::uuids::random_generator generator;
        const Scribe scribe(uniqId, generateRequestId(generator));

        impl = std::make_shared<poller::Poller>(
            poller::Poller::Type::cluster,
            std::move(uniqId),
            config.base,
            makeClusterShardsProvider(config.shardsProvider, hostsCache),
            db::getShardAdaptor(shardConfig.adaptor, shardPool, scribe, cache),
            cache
        );
    }

    void start(boost::asio::io_context& io) {
        impl->start(io);
    }

    void stop() {
        impl->stop();
    }

private:
    std::shared_ptr<poller::Poller> impl;
};

} // namespace sharpei::cloud
