#pragma once

#include <internal/cloud/cluster_shards_provider_config.h>
#include <internal/poller/shards_provider.h>
#include <internal/services/yc/yc_hosts_cache.h>
#include <internal/shard.h>

namespace sharpei::cloud {

using services::yc::YcHostsCachePtr;

class ClusterShardsProvider final : public poller::IShardsProvider {
public:
    ClusterShardsProvider(const ClusterShardsProviderConfig& config, YcHostsCachePtr hostsCache)
        : config(config), hostsCache(hostsCache) {}

    expected<std::vector<ShardWithoutRoles>> getAllShards(const TaskContextPtr& context) const override;

private:
    ClusterShardsProviderConfig config;
    YcHostsCachePtr hostsCache;
};

inline auto makeClusterShardsProvider(const ClusterShardsProviderConfig& config, YcHostsCachePtr hostsCache) {
    return std::make_shared<ClusterShardsProvider>(config, hostsCache);
}

} // namespace sharpei::cloud
