#pragma once

#include <internal/pa_config.h>
#include <internal/db/config.h>
#include <internal/cache/config.h>
#include <internal/cloud/cluster_poller_config.h>
#include <internal/services/iam/iam_config.h>
#include <internal/services/yc/yc_config.h>

namespace sharpei::cloud {

struct Config {
    PaConfig pa;
    ClusterPollerConfig poller;
    cache::CacheConfig cache;
    services::iam::IamConfig iam;
    services::yc::YcConfig yc;
    db::ShardConfig shard;
};

Config makeConfig(const yplatform::ptree& data);

} // namespace sharpei::cloud
