#pragma once

#include <internal/cloud/config.h>
#include <internal/config_reflection.h>

YREFLECTION_ADAPT_ADT(sharpei::cloud::ClusterShardsProviderConfig,
    YREFLECTION_AUTO_ATTR(port)
    YREFLECTION_AUTO_ATTR(dbname)
)

YREFLECTION_ADAPT_ADT(sharpei::cloud::ClusterPollerConfig,
    YREFLECTION_AUTO_ATTR(base)
    YREFLECTION_AUTO_ATTR(shards_provider, shardsProvider)
)

BOOST_FUSION_ADAPT_STRUCT(sharpei::services::iam::IamClientConfig,
    http
)

YREFLECTION_ADAPT_ADT(sharpei::services::iam::IamPollerConfig,
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, min_allowed_interval_sec, std::chrono::seconds, minAllowedInterval)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, min_interval_sec, std::chrono::seconds, minInterval)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, max_interval_sec, std::chrono::seconds, maxInterval)
    YREFLECTION_AUTO_ATTR(coroutine_stack_size, coroutineStackSize)
)

YREFLECTION_ADAPT_ADT(sharpei::services::iam::IamConfig,
    YREFLECTION_AUTO_ATTR(client)
    YREFLECTION_AUTO_ATTR(poller)
    YREFLECTION_AUTO_ATTR(jwt_file_path, jwtFilePath)
)

YREFLECTION_ADAPT_ADT(sharpei::services::yc::YcClientConfig,
    YREFLECTION_AUTO_ATTR(cluster_id, clusterId)
    YREFLECTION_AUTO_ATTR(http)
)

YREFLECTION_ADAPT_ADT(sharpei::services::yc::YcPollerConfig,
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, interval_sec, std::chrono::seconds, interval)
    YREFLECTION_AUTO_ATTR(coroutine_stack_size, coroutineStackSize)
    YREFLECTION_AUTO_ATTR(fs_hosts_cache_path, fsHostsCachePath)
)

BOOST_FUSION_ADAPT_STRUCT(sharpei::services::yc::YcConfig,
    client,
    poller
)

BOOST_FUSION_ADAPT_STRUCT(sharpei::cloud::Config,
    pa,
    poller,
    cache,
    iam,
    yc,
    shard
)
