#pragma once

#include <internal/cloud/cluster_poller.h>
#include <internal/cloud/config.h>
#include <internal/cache/cache.h>
#include <internal/services/iam/iam_poller.h>
#include <internal/services/yc/yc_poller.h>
#include <internal/thread_pool.h>

#include <yplatform/module.h>

namespace sharpei::cloud {

using services::iam::IamPoller;
using services::yc::YcPoller;
using services::yc::YcHostsCache;

class Module : public yplatform::module {
public:
    void init(const yplatform::ptree& data);
    void start();
    void stop();
    void fini();

    yplatform::ptree get_stats() const override final;

private:
    boost::asio::io_context io;
    Config config;
    yplatform::ptree httpClientConfig;
    cache::CachePtr cache;
    db::ShardPoolPtr shardPool;
    std::string uniqId;
    std::shared_ptr<IamPoller> iamPoller;
    std::shared_ptr<YcPoller> ycPoller;
    std::unique_ptr<ClusterPoller> poller;
    std::unique_ptr<IoThreadWorker> worker;

    YcHostsCache readFsHostsCache(const std::string& path) const;
};

} // namespace sharpei::cloud
