#pragma once

#include <memory>
#include <functional>
#include <chrono>
#include <yplatform/ptree.h>
#include <ymod_httpclient/call.h>
#include <internal/db/conn_info.h>
#include <internal/errors.h>
#include <internal/services/blackbox/blackbox_config.h>
#include <internal/db/config.h>
#include <internal/cache/config.h>
#include <internal/poller/meta_poller_config.h>
#include <internal/poller/shards_poller_config.h>
#include <internal/pa_config.h>
#include <internal/services/http_client_config.h>

namespace sharpei {

struct Config {
    db::MetaConfig meta;
    db::ShardConfig shard;
    db::DatabaseConfig peers;
    poller::MetaPollerConfig metaPoller;
    poller::ShardsPollerConfig shardsPoller;
    cache::CacheConfig cache;
    PaConfig pa;
    services::blackbox::BlackboxConfig blackbox;
    std::string tvmModule;
    std::size_t coroutineStackSize;
};

using ConfigPtr = std::shared_ptr<Config>;

ConfigPtr makeConfig(const yplatform::ptree& data);

} // namespace sharpei
