#pragma once

#include <internal/config.h>
#include <internal/db/config.h>
#include <internal/dc_vanga_config.h>

#include <yamail/data/reflection/reflection.h>

// clang-format off
YREFLECTION_ADAPT_ADT(sharpei::db::AuthInfo,
    YREFLECTION_AUTO_PROP(user)
    YREFLECTION_AUTO_PROP(password)
    YREFLECTION_AUTO_PROP(sslmode)
)

YREFLECTION_ADAPT_ADT(sharpei::db::ConnectionInfoWOHost,
    YREFLECTION_AUTO_ATTR(auth_info, authInfo)
    YREFLECTION_AUTO_ATTR(port)
    YREFLECTION_AUTO_ATTR(dbname)
)

YREFLECTION_ADAPT_ADT(sharpei::db::PoolConfig::DnsConfig,
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, cache_ttl_sec, std::chrono::seconds, cacheTtl)
)

YREFLECTION_ADAPT_ADT(sharpei::db::PoolConfig,
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, connect_timeout_ms, std::chrono::milliseconds, connectTimeout)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, queue_timeout_ms, std::chrono::milliseconds, queueTimeout)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, idle_timeout_ms, std::chrono::milliseconds, idleTimeout)
    YREFLECTION_AUTO_ATTR(max_connections, maxConnections)
    YREFLECTION_AUTO_ATTR(async_resolve, asyncResolve)
    YREFLECTION_AUTO_ATTR(ipv6_only, ipv6Only)
    YREFLECTION_AUTO_ATTR(dns)
)

YREFLECTION_ADAPT_ADT(sharpei::db::AdaptorConfig,
    YREFLECTION_AUTO_ATTR(conn_info, connInfoWOHost)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, request_timeout_ms, std::chrono::milliseconds, requestTimeout)
)

BOOST_FUSION_ADAPT_STRUCT(sharpei::db::DatabaseConfig,
    pool,
    adaptor
)

YREFLECTION_ADAPT_ADT(sharpei::db::ShardConfig::AdaptorConfig,
    YREFLECTION_AUTO_ATTR(auth_info, authInfo)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, request_timeout_ms, std::chrono::milliseconds, requestTimeout)
)

BOOST_FUSION_ADAPT_STRUCT(sharpei::db::ShardConfig,
    pool,
    adaptor,
    workers,
)

BOOST_FUSION_ADAPT_STRUCT(sharpei::db::Host,
    host,
    dc
)

YREFLECTION_ADAPT_ADT(sharpei::db::EndpointProviderConfig,
    YREFLECTION_AUTO_ATTR(use_meta_cache_based_provider_in_meta_pool, useMetaCacheBasedProviderInMetaPool)
    YREFLECTION_AUTO_ATTR(hostlist)
    YREFLECTION_AUTO_ATTR(dc_vanga, dcVanga)
    YREFLECTION_AUTO_ATTR(alive_hosts_threshold, aliveHostsThreshold)
)

YREFLECTION_ADAPT_ADT(sharpei::db::MetaConfig,
    YREFLECTION_AUTO_ATTR(db)
    YREFLECTION_AUTO_ATTR(endpoint_provider, endpointProvider)
)

YREFLECTION_ADAPT_ADT(sharpei::poller::PollerConfig,
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, interval_sec, std::chrono::seconds, interval)
    YREFLECTION_AUTO_ATTR(coroutine_stack_size, coroutineStackSize)
)

YREFLECTION_ADAPT_ADT(sharpei::poller::ShardsPollerConfig,
    YREFLECTION_AUTO_ATTR(meta_max_connections, metaMaxConnections)
    YREFLECTION_AUTO_ATTR(base)
)

YREFLECTION_ADAPT_ADT(sharpei::poller::MetaPollerConfig,
    YREFLECTION_AUTO_ATTR(base)
    YREFLECTION_AUTO_ATTR(enabled)
)

YREFLECTION_ADAPT_ADT(sharpei::cache::CacheConfig,
    YREFLECTION_AUTO_ATTR(history_capacity, historyCapacity)
    YREFLECTION_AUTO_ATTR(errors_limit, errorsLimit)
)

BOOST_FUSION_ADAPT_STRUCT(sharpei::PaConfig,
    log
)

YREFLECTION_ADAPT_ADT(ymod_httpclient::timeouts,
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, connect_ms, yplatform::time_traits::milliseconds, connect)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, total_ms, yplatform::time_traits::milliseconds, total)
)

BOOST_FUSION_ADAPT_STRUCT(ymod_httpclient::options,
    log_post_body,
    log_headers,
    reuse_connection,
    timeouts
)

 BOOST_FUSION_ADAPT_STRUCT(ymod_httpclient::cluster_client_options,
    log_post_body,
    log_headers,
    reuse_connection,
    timeouts,
    max_attempts
 )

BOOST_FUSION_ADAPT_STRUCT(sharpei::services::HttpClientConfig,
    module,
    options
)

BOOST_FUSION_ADAPT_STRUCT(sharpei::services::blackbox::BlackboxConfig,
    http
)

YREFLECTION_ADAPT_ADT(sharpei::Config,
    YREFLECTION_AUTO_ATTR(meta_connection, meta)
    YREFLECTION_AUTO_ATTR(shard_connection, shard)
    YREFLECTION_AUTO_ATTR(peers_connection, peers)
    YREFLECTION_AUTO_ATTR(shards_poller, shardsPoller)
    YREFLECTION_AUTO_ATTR(meta_poller, metaPoller)
    YREFLECTION_AUTO_ATTR(cache)
    YREFLECTION_AUTO_ATTR(pa)
    YREFLECTION_AUTO_ATTR(blackbox)
    YREFLECTION_AUTO_ATTR(tvm_module, tvmModule)
    YREFLECTION_AUTO_ATTR(coroutine_stack_size, coroutineStackSize)
)
// clang-format on
