#pragma once

#include <internal/server/handlers/get_user.h>

#include <boost/fusion/include/define_struct_inline.hpp>

namespace sharpei {
namespace datasync {
namespace server {
namespace handlers {

struct UserData {
    const sharpei::reflection::Shard& shard;
    const boost::optional<std::string>& data;
};

} // namespace handlers
} // namespace server
} // namespace datasync
} // namespace sharpei

BOOST_FUSION_ADAPT_STRUCT(
    sharpei::datasync::server::handlers::UserData,
    (const sharpei::reflection::Shard&, shard)
    (const boost::optional<std::string>&, data)
)

namespace sharpei {
namespace datasync {
namespace server {
namespace handlers {

struct GetUserResponseUserData {
    void operator ()(ymod_webserver::response_ptr response, const reflection::ShardWithoutRoles&, const boost::optional<std::string>&) const {
        using namespace ymod_webserver::helpers;
        using namespace ymod_webserver::helpers::transfer_encoding;
        return Response(*response).bad_request(fixed_size(format::text("unsupported mode")));
    }

    void operator ()(ymod_webserver::response_ptr response, const reflection::Shard& shard, const boost::optional<std::string>& data) const {
        using namespace ymod_webserver::helpers;
        using namespace ymod_webserver::helpers::transfer_encoding;
        return Response(*response).ok(fixed_size(format::json(UserData {shard, data})));
    }
};

template <class UserIdValue>
using GetUser = sharpei::server::handlers::BaseGetUser<sharpei::server::handlers::DefaultErrorHandler, GetUserResponseUserData, UserIdValue>;

} // namespace handlers
} // namespace server
} // namespace datasync
} // namespace sharpei
