#pragma once

#include <internal/db/adaptors/meta_adaptor.h>

#include <memory>

namespace sharpei::db {

class IMetaAdaptorFactory {
public:
    virtual ~IMetaAdaptorFactory() = default;

    BaseMetaAdaptorPtr getBaseMetaAdaptor(const AdaptorConfig& config,
                                          const MetaPoolPtr& pool,
                                          const Scribe& scribe) const {
        return std::make_shared<const detail::BaseMetaAdaptorImpl>(
            config, pool, scribe, getMetaMasterProvider(config, pool, scribe));
    }

    template <class UserIdValue>
    MetaAdaptorPtr<UserIdValue> getMetaAdaptor(const AdaptorConfig& config,
                                               const MetaPoolPtr& pool,
                                               const Scribe& scribe) const {
        return std::make_shared<const detail::MetaAdaptorImpl<UserIdValue>>(
            getBaseMetaAdaptor(config, pool, scribe), config, pool, scribe);
    }

private:
    virtual MetaMasterProviderPtr getMetaMasterProvider(const AdaptorConfig& config,
                                                        const MetaPoolPtr& pool,
                                                        const Scribe& scribe) const = 0;
};

using MetaAdaptorFactoryPtr = std::shared_ptr<IMetaAdaptorFactory>;

}  // namespace sharpei::db
