#pragma once

#include <internal/db/adaptors/meta_master_provider.h>

#include <internal/cache/cache.h>
#include <internal/logger.h>
#include <internal/poller/meta_shards_provider.h>

namespace sharpei::db {

class MetaCacheBasedMetaMasterProvider : public IMetaMasterProvider {
public:
    MetaCacheBasedMetaMasterProvider(cache::CachePtr metaCache, const Scribe& scribe)
        : metaCache_(std::move(metaCache)), scribe_(scribe) {
    }

    void getMaster(const GetMasterHandler& handler, const ErrorHandler& errorHandler) const {
        if (auto master = metaCache_->getAliveShardMaster(poller::MetaShardsProvider::shardId)) {
            handler(master.value().host);
        } else {
            const auto ec = ExplainedError(Error::metaMasterProviderError, "no alive meta database master");
            LOGDOG_(
                scribe_.logger, error, log::where_name = "meta_cache_based_meta_master_provider", log::error_code = ec);
            errorHandler(ec);
        }
    }

private:
    cache::CachePtr metaCache_;
    Scribe scribe_;
};

}  // namespace sharpei::db
