#pragma once

#include <internal/errors.h>

#include <functional>
#include <string>

namespace sharpei::db {

struct IMetaMasterProvider {
    using GetMasterHandler = std::function<void(std::string)>;
    using ErrorHandler = std::function<void(const ExplainedError&)>;

    virtual ~IMetaMasterProvider() = default;

    virtual void getMaster(const GetMasterHandler& handler,
                           const ErrorHandler& errorHandler) const = 0;
};

using MetaMasterProviderPtr = std::shared_ptr<IMetaMasterProvider>;

}  // namespace sharpei::db
