#pragma once

#include <internal/db/pools/meta_pool.h>
#include <internal/db/query.h>
#include <internal/errors.h>
#include <internal/helpers.h>
#include <internal/logger.h>
#include <internal/shard.h>

namespace sharpei::db {

namespace detail {

class AsyncExecutor {
public:
    virtual ~AsyncExecutor() = default;
    virtual void execute() = 0;

protected:
    using ErrorHandler = std::function<void(const ExplainedError&)>;

    virtual apq::query makeQuery() const = 0;
    virtual std::string getProfilingId() const = 0;

    AsyncExecutor(const AdaptorConfig& config,
                  const MetaPoolPtr& pool,
                  const Scribe& scribe,
                  const ErrorHandler& errorHandler)
        : config_(config), pool_(pool), scribe_(scribe), errorHandler_(errorHandler) {
    }

    AdaptorConfig config_;
    MetaPoolPtr pool_;
    Scribe scribe_;
    ErrorHandler errorHandler_;
    std::unique_ptr<apq::query> query_;
};

}  // namespace detail

class RequestExecutor : public detail::AsyncExecutor,
                        public std::enable_shared_from_this<RequestExecutor> {
public:
    virtual ~RequestExecutor() = default;

    virtual void execute();

protected:
    virtual void onEmptyResult() = 0;
    virtual void onCorrectResult(apq::row_iterator it) = 0;

    RequestExecutor(const AdaptorConfig& config,
                    const MetaPoolPtr& pool,
                    const Scribe& scribe,
                    const ErrorHandler& errorHandler);

    Shard::Database::Address getAddrFromPgResult(apq::row_iterator it);

private:
    void handleRequest(const apq::result& res, apq::row_iterator it);
};

}  // namespace sharpei::db
