#pragma once

#include <memory>
#include <functional>
#include <internal/logger.h>
#include <internal/config.h>
#include <internal/cache/cache.h>
#include <internal/errors.h>
#include <internal/db/pools/connection_pool.h>

namespace sharpei {
namespace db {

class ShardAdaptor {
public:
    typedef std::function<void(const Shard::Databases&)> GetHostsHandler;
    typedef std::function<void(const ExplainedError&)> ErrorHandler;
    typedef std::function<void()> FinishHandler;
    typedef std::set<Shard::Database::Role> Roles;
    virtual ~ShardAdaptor() {}
    virtual void resetHostCache(const ShardWithoutRoles& shard, const FinishHandler& handler,
                                const ErrorHandler& errorHandler) = 0;
};

using ShardAdaptorPtr = std::shared_ptr<ShardAdaptor>;
using ShardPoolPtr = std::shared_ptr<IConnectionPool>;

ShardAdaptorPtr getShardAdaptor(const ShardConfig::AdaptorConfig& config, const ShardPoolPtr& pool,
                                const Scribe& scribe, const cache::CachePtr& cache);

} // namespace db
} // namespace sharpei
