#pragma once

#include <internal/db/conn_info.h>
#include <internal/dc.h>
#include <internal/dc_vanga_config.h>

#include <chrono>
#include <string>
#include <vector>

namespace sharpei::db {

struct PoolConfig {
    struct DnsConfig {
        std::chrono::seconds cacheTtl;
    };

    std::chrono::milliseconds connectTimeout;
    std::chrono::milliseconds queueTimeout;
    std::chrono::milliseconds idleTimeout;
    std::size_t maxConnections;
    bool asyncResolve;
    bool ipv6Only;
    DnsConfig dns;
};

struct AdaptorConfig {
    ConnectionInfoWOHost connInfoWOHost;
    std::chrono::milliseconds requestTimeout;
};

struct DatabaseConfig {
    PoolConfig pool;
    AdaptorConfig adaptor;
};

struct ShardConfig {
    struct AdaptorConfig {
        AuthInfo authInfo;
        std::chrono::milliseconds requestTimeout;
    };

    unsigned workers;
    PoolConfig pool;
    AdaptorConfig adaptor;
};

struct Host {
    std::string host;
    DC dc;
};

struct EndpointProviderConfig {
    bool useMetaCacheBasedProviderInMetaPool = false;
    std::vector<Host> hostlist;

    // If present, MetaCacheBasedEndpointProvider will be able to
    // determine in which DC the current instance of Sharpei is running.
    // Then it will prioritize metabase nodes from this DC.
    dc_vanga::Rules dcVanga;
    std::size_t aliveHostsThreshold;
};

struct MetaConfig {
    DatabaseConfig db;
    EndpointProviderConfig endpointProvider;
};

inline bool operator<(const Host& lhs, const Host& rhs) {
    return lhs.host < rhs.host;
}

inline bool operator==(const Host& lhs, const Host& rhs) {
    return lhs.host == rhs.host;
}

} // namespace sharpei::db
