#pragma once

#include <internal/db/conn_info.h>

namespace sharpei {
namespace db {

class IEndpointProvider {
public:
    using Endpoint = ConnectionInfo;

    virtual ~IEndpointProvider() = default;
    virtual Endpoint getNext() = 0;
};

using EndpointProviderPtr = std::shared_ptr<IEndpointProvider>;

}  // namespace db
}  // namespace sharpei
