#pragma once

#include <internal/db/config.h>
#include <internal/db/ep/endpoint_provider.h>

namespace sharpei {
namespace db {

class SingleEndpointProvider : public IEndpointProvider {
public:
    explicit SingleEndpointProvider(const ConnectionInfo& endpoint) : endpoint_(endpoint) {
    }

    Endpoint getNext() override {
        return endpoint_;
    }

private:
    Endpoint endpoint_;
};

inline auto makeSingleEndpointProvider(const MetaConfig& config) {
    /*
     * localhost is hardcoded for the time of testing of the new MetaPoller.
     * Eventually, MetaPool will be equipped with another EndpointProvider implementation based on metaCache_.
     */
    return std::make_shared<SingleEndpointProvider>(ConnectionInfo(config.db.adaptor.connInfoWOHost, "localhost"));
}

}  // namespace db
}  // namespace sharpei
