#pragma once

#include <mail/sharpei/include/internal/shard.h>

#include <memory>

namespace sharpei::db {

struct IFiltrationStrategy {
    virtual ~IFiltrationStrategy() = default;

    virtual bool isLagAcceptable(Shard::Database::State::ReplicationLag) const = 0;

    virtual bool skipMaster() const = 0;
};

using FiltrationStrategyPtr = std::shared_ptr<IFiltrationStrategy>;

struct AcceptingAllNodesFiltrationStrategy : IFiltrationStrategy {
    bool isLagAcceptable(Shard::Database::State::ReplicationLag) const override;

    bool skipMaster() const override;
};

std::vector<Shard::Database> filterDatabases(const Shard::Databases& databases, const IFiltrationStrategy& filter);

} // namespace sharpei::db
