#pragma once

#include <apq/connection_pool.hpp>

namespace sharpei {
namespace db {

class ApqConnectionPool {
public:
    using Stats = apq::connection_pool::stats;

    virtual ~ApqConnectionPool() = default;

    ApqConnectionPool(boost::asio::io_service& service) : impl_(service) {
    }

    void set_conninfo(const std::string& conninfo) {
        impl_.set_conninfo(conninfo);
    }

    void set_limit(std::size_t value) {
        impl_.set_limit(value);
    }

    void set_connect_timeout(apq::time_traits::duration_type value) {
        impl_.set_connect_timeout(value);
    }

    void set_queue_timeout(apq::time_traits::duration_type value) {
        impl_.set_queue_timeout(value);
    }

    void set_idle_timeout(apq::time_traits::duration_type value) {
        impl_.set_idle_timeout(value);
    }

    void set_async_resolve(bool enabled) {
        impl_.set_async_resolve(enabled);
    }

    void set_ipv6_only(bool enabled) {
        impl_.set_ipv6_only(enabled);
    }

    virtual void async_request(const apq::query& query, apq::connection_pool::request_handler_t handler,
                               apq::result_format rt, apq::time_traits::duration_type tm) {
        impl_.async_request(apq::fake_task_context(), query, handler, rt, tm);
    }

    virtual void async_update(const apq::query& query, apq::connection_pool::update_handler_t handler,
                              apq::time_traits::duration_type tm) {
        impl_.async_update(apq::fake_task_context(), query, handler, tm);
    }

    Stats stats() const {
        return impl_.get_stats();
    }

    apq::connection_pool& pool() {
        return impl_;
    }

private:
    apq::connection_pool impl_;
};

}  // namespace db
}  // namespace sharpei
