#pragma once

#include <memory>
#include <unordered_map>

#include <yplatform/reactor.h>

#include <internal/db/pools/connection_pool.h>

namespace sharpei {
namespace db {

class ThreadConnectionPoolMap : public IConnectionPool {
public:
    using Services = std::vector<boost::asio::io_service*>;

    ThreadConnectionPoolMap(const Services& services, const PoolConfig& poolCfg) {
        for (auto service : services) {
            pools_.emplace(service, makeConnectionPool(poolCfg, *service));
        }
    }

    ConnectionPoolPtr get(const ConnectionInfo& connInfo) override {
        return pool().get(connInfo);
    }

    Stats stats() override;

private:
    using Pool = IConnectionPool;
    using PoolPtr = std::shared_ptr<Pool>;
    using Pools = std::unordered_map<boost::asio::io_service*, PoolPtr>;

    std::string conninfo_;
    Pools pools_;

    Pool& pool() const {
        return *pools_.at(yplatform::global_net_reactor->get_pool()->io());
    }
};

}  // namespace db
}  // namespace sharpei
