#pragma once

#include <internal/user.h>

#include <apq/query.hpp>

#include <variant>

namespace sharpei {
namespace db {

inline void bind(apq::query&, std::monostate) {}

inline void bind(apq::query& query, const std::int64_t value) {
    query.bind_const_int64(value);
}

inline void bind(apq::query& query, BasicUserId<std::int64_t> value) {
    query.bind_const_int64(value.value());
}

inline void bind(apq::query& query, const BasicUserId<std::string>& value) {
    query.bind_const_string(value.value());
}

inline std::string makeErrorMessage(const apq::query& query, const std::string& reason) {
    std::ostringstream stream;
    stream << "query=[" << query.text_ << "], values=[";
    for (std::size_t i = 0; i < query.values_.size(); ++i) {
        stream << '$' << i << "={";
        query.values_[i].second->stream(stream);
        stream << "}, ";
    }
    stream << "], reason=[" << reason << "]";
    return stream.str();
}

} // namespace db
} // namespace sharpei
