#pragma once

#include <yamail/data/reflection/reflection.h>

namespace sharpei::db {

// All textual DC names used in codebase must be either
// 1. come from metabase https://a.yandex-team.ru/arc/trunk/arcadia/mail/pg/sharddb/sharddb.sql?rev=r5741241#L62
//    where their values are restricted todo(nickitat): MAILPG-4042
// 2. obtained by calling `yamail::data::deserialization::to_string` on one of the following enumerators
// clang-format off
enum class DC {
    iva,
    man,
    myt,
    sas,
    vla
};

}  // namespace sharpei::db

YREFLECTION_ADAPT_ENUM(sharpei::db::DC,
    iva,
    man,
    myt,
    sas,
    vla
)
