#pragma once

#include <internal/dc.h>
#include <yamail/data/reflection/reflection.h>

#include <optional>
#include <string>
#include <vector>

namespace sharpei::dc_vanga {

struct Mapping {
    db::DC dc;
    std::string dcId;
};

struct RuleConfig {
    // Regex conformant with the ECMAScript grammar.
    // Should contain capture group named 'dcid'.
    // In case of a match, its value will be mapped into one
    // of the actual DCs names using the |mapping| defined below.
    std::string regex;

    // Determines a mapping from DC name representation in hostname
    // into actual DC name.
    // For example, letter 'h' in hostname sharpei01h.mail.yandex.net
    // represents Sasovo, so |mapping| for Sharpei running on this host
    // should contain Mapping{.dc=DC::sas, .dcId="h"}.
    std::vector<Mapping> mapping;
};

using Rules = std::vector<dc_vanga::RuleConfig>;

}  // namespace sharpei::dc_vanga

// clang-format off
YREFLECTION_ADAPT_ADT(sharpei::dc_vanga::Mapping,
    YREFLECTION_AUTO_ATTR(dc)
    YREFLECTION_AUTO_ATTR(dcid, dcId)
)

BOOST_FUSION_ADAPT_STRUCT(sharpei::dc_vanga::RuleConfig,
    regex,
    mapping
)
