#pragma once

#include <internal/config.h>

namespace sharpei::mail {

class Config {
public:
    using Base = sharpei::Config;
    using BasePtr = sharpei::ConfigPtr;

    BasePtr base() const {
        return base_;
    }

    struct Registration {
        unsigned getAliveMasterAttempts;
        std::chrono::milliseconds mdbTimeout;
        std::chrono::milliseconds sharddbTimeout;
        unsigned maxCommitTries;
        unsigned maxRollbackTries;
        unsigned retryDelayBase;
        bool enableWelcomeLetters;
        bool createBaseFilters;
    } registration;

    friend std::shared_ptr<Config> makeConfig(sharpei::ConfigPtr base, const yplatform::ptree& data);

private:
    BasePtr base_;
};

using ConfigPtr = std::shared_ptr<Config>;

ConfigPtr makeConfig(sharpei::ConfigPtr base, const yplatform::ptree& data);

} // namespace sharpei::mail
