#pragma once

#include <internal/shard.h>
#include <internal/logger.h>
#include <internal/errors.h>
#include <internal/mail/config.h>
#include <internal/cache/cache.h>
#include <internal/user.h>
#include <internal/db/adaptors/peers_adaptor.h>
#include <internal/db/adaptors/shard_adaptor.h>

namespace sharpei {
namespace mail {
namespace db {

using PeersPoolPtr = sharpei::db::PeersPoolPtr;
using ShardPoolPtr = sharpei::db::ShardPoolPtr;

struct RegParams {
    BasicUserId<std::int64_t> uid;
    std::string country;
    std::string lang;
    bool enableWelcome;     // 'true' if welcome letters is switched-on in config
    bool needsWelcome;      // 'true' if user needs welcome letters
    bool baseFilters;
    Shard::Id shardId;
    Shard::Database::Address mdbMaster;
    std::string sharddbMasterHost;
    std::string requestId;
    std::string verstkaSessionKey;
    std::string sessionId;
};

class RegAdaptor {
public:
    typedef std::function<void(const ExplainedError&)> Handler;

    virtual ~RegAdaptor() {}
    virtual void registerUser(const RegParams& params, const Handler& handler) = 0;
};

typedef std::shared_ptr<RegAdaptor> RegAdaptorPtr;

RegAdaptorPtr getRegAdaptor(ConfigPtr config, const Scribe& scribe, ShardPoolPtr shardPool, PeersPoolPtr peersPool);

} // namespace db
} // namespace mail
} // namespace sharpei
