#ifndef SHARPEI_MAIL_REFLECTION_REG_RESPONSE_H
#define SHARPEI_MAIL_REFLECTION_REG_RESPONSE_H

#include <yamail/data/serialization/json_writer.h>
#include <internal/reflection/shard.h>
#include <internal/errors.h>
#include <internal/shard.h>

namespace sharpei {
namespace mail {
namespace reflection {

struct RegResponse {
    using Shard = sharpei::reflection::Shard;
    using OptShard = boost::optional<Shard>;

    std::string result;
    OptShard shard;
    std::string description;

    RegResponse()
    {}

    RegResponse(Error error_, const std::string& description_)
        : result(make_error_code(error_).message())
        , description(description_)
    {}

    RegResponse(Error error_, Shard shard_, const std::string& description_)
        : result(make_error_code(error_).message())
        , shard(std::move(shard_))
        , description(description_)
    {}
};

} // namespace reflection
} // namespace mail
} // namespace sharpei

BOOST_FUSION_ADAPT_STRUCT(sharpei::mail::reflection::RegResponse,
    (std::string, result)
    (std::string, description)
    (sharpei::mail::reflection::RegResponse::OptShard, shard)
)

#endif // SHARPEI_REFLECTION_REG_RESPONSE_H
