#ifndef SHARPEI_MAIL_STATS_H
#define SHARPEI_MAIL_STATS_H

#include <internal/stats.h>

namespace sharpei {
namespace mail {

class Stats : public yplatform::module_stats {
public:
    using Base = sharpei::Stats;
    using PtreePtr = Base::PtreePtr;

    Stats(GetMetaPool getMetaPool, GetShardPool getShardPool, GetPeersPool getPeersPool)
        : base_(getMetaPool, getShardPool), getPeersPool_(getPeersPool) {}

    PtreePtr core_get_stat() const override final {
        const auto result = base_.core_get_stat();
        result->add_child("peers", Base::makePtree(getPeersPool_()->stats()));
        return result;
    }

private:
    Base base_;
    GetPeersPool getPeersPool_;
};

} // namespace mail
} // namespace sharpei

#endif // SHARPEI_MAIL_STATS_H
