#pragma once

#include <internal/server/request_context.h>
#include <user_journal/journal.h>
#include <user_journal/service.h>

namespace sharpei {

struct UserJournalParams {
    std::string uid;
    std::string userIp;
    std::string requestId;
};

inline UserJournalParams getUserJournalParams(const server::RequestContext& req) {
    return {
        req.getRequiredArg<std::string>("uid"),
        req.userIp(),
        req.requestId()
    };
}

using UserJournal = ::user_journal::Journal;
using UserJournalPtr = std::shared_ptr<UserJournal>;

inline UserJournalPtr getUserJournal(const UserJournalParams& params,
                                     const std::string& module,
                                     ::user_journal::ServicePtr service) {
    using namespace user_journal::parameters;
    return std::make_shared<UserJournal>(
                service->createJournal(params.uid,
                                       id::module(module),
                                       id::ip(params.userIp),
                                       id::requestId(params.requestId)));
}

} // namespace sharpei
