#pragma once

#include <user_journal/logging.h>
#include <internal/logger.h>

namespace sharpei {

class UserJournalLog: public ::user_journal::logging::Log {
public:
    virtual void warning(const std::string& uid, const std::string& method, const std::string& message, int code) {
        auto ec = std::error_code{code, std::generic_category()};
        LOGDOG_(log::GetLogger(log::sharpeiLogKey), warning, log::where_name="user_journal",
            log::method=method, log::message=message, log::uid=uid, log::error_code=ec);
    }

    virtual void error(const std::string& uid, const std::string& method, const std::string& message, int code) {
        auto ec = std::error_code{code, std::generic_category()};
        LOGDOG_(log::GetLogger(log::sharpeiLogKey), error, log::where_name="user_journal",
            log::method=method, log::message=message, log::uid=uid, log::error_code=ec);
    }

    virtual void notice(const std::string& uid, const std::string& method, const std::string& message ) {
        LOGDOG_(log::GetLogger(log::sharpeiLogKey), notice, log::where_name="user_journal",
            log::method=method, log::message=message, log::uid=uid);
    }

    virtual void debug(const std::string& uid, const std::string& method, const std::string& message ) {
        LOGDOG_(log::GetLogger(log::sharpeiLogKey), debug, log::where_name="user_journal",
            log::method=method, log::message=message, log::uid=uid);
    }
};

} // namespace sharpei
