#pragma once

#include <user_journal/parameters/operation_parameters.h>
#include <internal/mail/db/adaptors/reg_adaptor.h>

namespace user_journal {
namespace parameters {
namespace id {

using RegParams = ::sharpei::mail::db::RegParams;

template<>
struct Wrapper<RegParams> {
    void map(const Mapper & m) const {
        m.mapValue(v_.country, "country");
        m.mapValue(v_.lang, "lang");
        m.mapValue(v_.enableWelcome, "enableWelcome");
        m.mapValue(v_.needsWelcome, "needsWelcome");
        m.mapValue(v_.baseFilters, "baseFilters");
        m.mapValue(std::to_string(v_.shardId), "shardId");
        m.mapValue(v_.verstkaSessionKey, "verstkaSessionKey");
        m.mapValue(v_.sessionId, "sessionId");
    }
    void set(const RegParams& v) {
        v_ = v;
    }
private:
    RegParams v_;
};

} // namespace id

using Registration = OperationParameters<Target::account, Operation::registration, id::RegParams>;

} // namespace parameters
} // namespace user_journal
