#ifndef SHARPEI_MODE_H
#define SHARPEI_MODE_H

#include <string>
#include <unordered_map>
#include <boost/bimap.hpp>

namespace sharpei {

struct Mode {
    enum Value {
        Unknown = 0,
        Master,
        Replica,
        WriteOnly,
        WriteRead,
        ReadWrite,
        ReadOnly,
        All
    } value;

    using Bimap = boost::bimap<Value, std::string>;

    static const Bimap map;

    Mode(Value value = Unknown) : value(value) {}
    Mode(const std::string& str) : value(valueFromString(str)) {}

    static Value valueFromString(const std::string& str) {
        const auto it = map.right.find(str);
        if (it == map.right.end()) {
            return Unknown;
        }
        return it->second;
    }

    std::string toString() const {
        const auto it = map.left.find(value);
        if (it == map.left.end()) {
            return "unknown";
        }
        return it->second;
    }

    bool operator ==(Mode other) const {
        return value == other.value;
    }
};

} // namespace sharpei

#endif // SHARPEI_MODE_H
