#pragma once

#include <internal/cache/cache.h>
#include <internal/config.h>
#include <internal/db/adaptors/meta_adaptor.h>
#include <internal/db/adaptors/meta_adaptor_factory.h>
#include <internal/db/adaptors/peers_adaptor.h>
#include <internal/db/adaptors/shard_adaptor.h>
#include <internal/helpers.h>
#include <internal/thread_pool.h>
#include <internal/logger.h>
#include <internal/poller/meta_poller.h>
#include <internal/poller/shards_poller.h>

#include <yplatform/module.h>

namespace sharpei {

class Module: public yplatform::module {
public:
    virtual void init(const yplatform::ptree& xml);
    virtual void start();
    virtual void stop();
    virtual void fini();

    virtual yplatform::ptree get_stats() const override;

protected:
    ConfigPtr getConfig() const;
    cache::CachePtr getShardsCache() const;
    cache::CachePtr getMetaCache() const;
    db::MetaPoolPtr getMetaPool() const;
    db::ShardPoolPtr getShardPool() const;
    db::PeersPoolPtr getPeersPool() const;
    db::MetaAdaptorFactoryPtr getMetaAdaptorFactory() const;

private:
    ConfigPtr config_;
    cache::CachePtr shardsCache_;
    cache::CachePtr metaCache_;
    db::MetaPoolPtr metaPool_;
    db::MetaAdaptorFactoryPtr metaAdaptorFactory_;

    db::ShardPoolPtr shardPool_;
    std::unique_ptr<ThreadPool> shardWorkers_;

    db::PeersPoolPtr peersPool_;
    boost::asio::io_service peersIos_;
    std::unique_ptr<IoThreadWorker> peersWorker_;

    std::unique_ptr<poller::ShardsPoller> shardsPoller_;
    std::unique_ptr<poller::MetaPoller> metaPoller_;
};

} // namespace sharpei
