#ifndef SHARPEI_ONCE_H
#define SHARPEI_ONCE_H

#include <atomic>

namespace sharpei {

class OnceBarrier {
public:
    OnceBarrier()
        : wasCalled_(false)
    {}

    bool testAndSet() {
        return !wasCalled_.exchange(true);
    }

    std::atomic_bool wasCalled_;
};

template <typename Action>
class OnceAction {
public:
    OnceAction(Action handler)
        : action_(handler)
    {}

    template <typename... Args>
    void operator()(Args&&... args) {
        if (barrier_.testAndSet()) {
            action_(std::forward<Args>(args)...);
        }
    }

private:
    const Action action_;
    OnceBarrier barrier_;
};

} // namespace sharpei

#endif // SHARPEI_ONCE_H
