#pragma once

#include <internal/shard.h>
#include <internal/task_context.h>
#include <internal/expected.h>

namespace sharpei::poller {

struct IShardsProvider {
    virtual ~IShardsProvider() = default;
    virtual expected<std::vector<ShardWithoutRoles>> getAllShards(const TaskContextPtr& context) const = 0;
};

using ShardsProviderPtr = std::shared_ptr<IShardsProvider>;

} // namespace sharpei::poller
