#pragma once

#include <internal/poller/poller.h>
#include <internal/poller/meta_shards_provider.h>

namespace sharpei::poller {

class MetaPoller {
public:
    MetaPoller(const PollerConfig& pollerConfig, const db::MetaConfig& metaConfig, cache::CachePtr cache) {
        const auto uniqId = "meta_poller";
        boost::uuids::random_generator generator;
        const Scribe scribe(uniqId, generateRequestId(generator));

        auto shardsProvider =
            std::make_shared<MetaShardsProvider>(metaConfig.db.adaptor.connInfoWOHost.dbname,
                                                 metaConfig.db.adaptor.connInfoWOHost.port, metaConfig.endpointProvider.hostlist);
        auto pool = db::makeConnectionPool(metaConfig.db.pool, io);
        const auto adaptor = db::ShardConfig::AdaptorConfig{.authInfo = metaConfig.db.adaptor.connInfoWOHost.authInfo,
                                                            .requestTimeout=metaConfig.db.adaptor.requestTimeout};
        impl = std::make_shared<poller::Poller>(
            poller::Poller::Type::meta,
            uniqId,
            pollerConfig,
            std::move(shardsProvider),
            db::getShardAdaptor(adaptor, std::move(pool), scribe, cache),
            cache
        );
        worker = std::make_unique<IoThreadWorker>(uniqId, io);
    }

    void start() {
        impl->start(io);
    }

    void stop() {
        impl->stop();
        worker->stop();
        io.stop();
    }

private:
    boost::asio::io_context io;
    std::unique_ptr<IoThreadWorker> worker;
    std::shared_ptr<poller::Poller> impl;
};

} // namespace sharpei::poller
