#pragma once

#include <internal/db/config.h>
#include <internal/poller/ishards_provider.h>

namespace sharpei::poller {

class MetaShardsProvider final : public poller::IShardsProvider {
public:
    using Hostlist = std::vector<db::Host>;
    inline static constexpr Shard::Id shardId{0};
    inline static const Shard::Name shardName{"sharddb"};

    MetaShardsProvider(const std::string& dbname, unsigned port, const Hostlist& hostlist)
    : dbname(dbname), port(port), hostlist(hostlist) {
    }

    expected<std::vector<ShardWithoutRoles>> getAllShards(const TaskContextPtr& context) const override;

private:
    const std::string dbname;
    const unsigned port;
    const Hostlist hostlist;
};

}  // namespace sharpei::poller
