#pragma once

#include <internal/poller/shards_provider.h>
#include <internal/db/adaptors/shard_adaptor.h>
#include <internal/cache/cache.h>
#include <internal/poller/poller_config.h>
#include <internal/logger.h>
#include <internal/guarded.h>
#include <internal/thread_pool.h>
#include <internal/expected.h>

#include <boost/asio/spawn.hpp>

#include <future>

namespace sharpei::poller {

class Poller : public std::enable_shared_from_this<Poller> {
public:
    enum class Type {
        cluster,
        meta,
        shards
    };

    Poller(Type type, std::string uniqId, const PollerConfig& config, ShardsProviderPtr shardsProvider,
           db::ShardAdaptorPtr shardAdaptor, cache::CachePtr cache);

    void start(boost::asio::io_context& io);
    void stop();

private:
    // For awaiting cache readiness on startup
    using PromisePtr = std::shared_ptr<std::promise<void>>;

    expected<void> poll(const TaskContextPtr& context, PromisePtr promise);
    expected<void> resetCache(const TaskContextPtr& context, const std::vector<ShardWithoutRoles>& shards, PromisePtr promise);

    const Type type;
    std::string uniqId;
    PollerConfig config;
    ShardsProviderPtr shardsProvider;
    db::ShardAdaptorPtr shardAdaptor;
    cache::CachePtr cache;
    std::atomic_bool shouldStop;
};

} // namespace sharpei::poller
