#pragma once

#include <internal/db/adaptors/meta_adaptor.h>
#include <internal/poller/ishards_provider.h>
#include <internal/async_operation.h>

namespace sharpei::poller {

class ShardsProvider final : public IShardsProvider {
public:
    ShardsProvider(db::BaseMetaAdaptorPtr impl) : impl(impl) {}

    expected<std::vector<ShardWithoutRoles>> getAllShards(const TaskContextPtr& context) const override {
        ExplainedError ec;
        auto shards = performAsyncOperation<std::vector<ShardWithoutRoles>, SplitHandlersAsyncOperation>(
            io_result::make_yield_context(context->yield())[ec],
            [impl = this->impl] (auto onValue, auto onError) {
                impl->getAllShards(std::move(onValue), std::move(onError));
            }
        );

        if (ec) {
            return make_unexpected(std::move(ec));
        }

        return {std::move(shards)};
    }

private:
    db::BaseMetaAdaptorPtr impl;
};

inline auto makeShardsProvider(db::BaseMetaAdaptorPtr impl) {
    return std::make_shared<ShardsProvider>(impl);
}

} // namespace sharpei::poller
