#ifndef SHARPEI_RANDOM_H
#define SHARPEI_RANDOM_H

#include <random>
#include <chrono>
#include <memory>
#include <boost/thread/tss.hpp>

namespace sharpei {

inline std::minstd_rand& threadLocalGenerator() {
    static thread_local std::minstd_rand result(std::chrono::system_clock::now().time_since_epoch().count());
    return result;
}

struct ThreadLocalRandomGenerator {
    unsigned rand(unsigned from, unsigned to) {
        std::uniform_int_distribution<unsigned> dist(from, to);
        return dist(threadLocalGenerator());
    }
};

class SeededRandomGenerator {
public:
    SeededRandomGenerator(int seed = 0)
        : engine_(seed)
    {}

    unsigned rand(unsigned from, unsigned to) {
        std::uniform_int_distribution<unsigned> dist(from, to);
        return dist(engine_);
    }

private:
    std::minstd_rand engine_;
};

} // namespace sharpei

#endif // SHARPEI_RANDOM_H
