#pragma once

#include <random>
#include <chrono>

namespace sharpei {

class RandomIntervalGenerator {
public:
    RandomIntervalGenerator(std::chrono::steady_clock::duration min, std::chrono::steady_clock::duration max,
            std::chrono::steady_clock::duration minAllowed)
        : min(min), max(max), minAllowed(minAllowed) {}

    std::chrono::steady_clock::duration generate() {
        const auto divisor = 1l << divisorPower;
        std::uniform_int_distribution<std::uint64_t> distribution(
            static_cast<std::uint64_t>(std::max(min / divisor, minAllowed).count()),
            static_cast<std::uint64_t>(std::max(max / divisor, minAllowed).count())
        );
        return std::chrono::steady_clock::duration(distribution(generator));
    }

    void reset() {
        divisorPower = 0;
    }

    void decrease() {
        divisorPower = std::min(
            divisorPower + 1,
            static_cast<std::int64_t>(sizeof(divisorPower) * sizeof(std::byte) - 1)
        );
    }

private:
    std::mt19937_64 generator {static_cast<std::uint64_t>(std::chrono::system_clock::now().time_since_epoch().count())};
    std::chrono::steady_clock::duration min;
    std::chrono::steady_clock::duration max;
    std::chrono::steady_clock::duration minAllowed;
    std::int64_t divisorPower = 0;
};

} // namespace sharpei
