#ifndef SHARPEI_SERVER_BIND_H
#define SHARPEI_SERVER_BIND_H

#include <yplatform/find.h>
#include <ymod_webserver/server.h>

namespace sharpei {
namespace server {

template <class T, class ... Args>
void bindHandler(const std::string& location, Args&& ... args) {
    const auto handler = std::make_shared<T>(std::forward<Args>(args) ...);
    const auto server = yplatform::find<ymod_webserver::server>("web_server");
    server->bind("", {location}, [=] (ymod_webserver::response_ptr stream) {
        handler->process(stream);
    });
}

} // namespace server
} // namespace sharpei

#endif // SHARPEI_SERVER_BIND_H
