#pragma once

#include <internal/db/adaptors/meta_adaptor_factory.h>
#include <internal/server/handlers/base.h>
#include <internal/server/handlers/detail/create_user_performer.h>

namespace sharpei {
namespace server {
namespace handlers {

using sharpei::server::handlers::Base;
using sharpei::server::RequestContext;

template <class UserIdValue>
class CreateUser : public Base {
public:
    CreateUser(ConfigPtr config,
               cache::CachePtr cache,
               db::MetaPoolPtr metaPool,
               db::PeersPoolPtr peersPool,
               db::MetaAdaptorFactoryPtr metaAdaptorFactory)
        : config(config),
          cache(cache),
          metaPool(metaPool),
          peersPool(peersPool),
          metaAdaptorFactory(metaAdaptorFactory) {
    }

private:
    ymod_webserver::methods::http_method method() const override final {
        return ymod_webserver::methods::mth_post;
    }

    void execute(RequestContext& context) const override final;

    ConfigPtr config;
    cache::CachePtr cache;
    db::MetaPoolPtr metaPool;
    db::PeersPoolPtr peersPool;
    db::MetaAdaptorFactoryPtr metaAdaptorFactory;
};

template <class UserIdValue>
void CreateUser<UserIdValue>::execute(RequestContext& context) const {
    using PeersAdaptor = db::PeersAdaptor<UserIdValue>;
    using Performer = CreateUserPerformer<PeersAdaptor, UserIdValue>;
    auto metaAdaptor = metaAdaptorFactory->getMetaAdaptor<UserIdValue>(
        config->meta.db.adaptor, metaPool, context.scribe);
    PeersAdaptor peersAdaptor(config->peers.adaptor, context.scribe, peersPool);
    const auto performer = std::make_shared<Performer>(context, config, cache,
        std::move(metaAdaptor), std::move(peersAdaptor));
    performer->perform();
}

} // namespace handlers
} // namespace server
} // namespace sharpei
