#pragma once

#include <internal/db/adaptors/meta_adaptor_factory.h>
#include <internal/server/handlers/base.h>
#include <internal/server/handlers/detail/get_domain_performer.h>

#include <internal/services/utils.h>
#include <internal/services/blackbox/blackbox_impl.h>

namespace sharpei::server::handlers {

using sharpei::server::handlers::Base;
using sharpei::server::RequestContext;

template <class GetIoContext>
class GetDomain : public Base {
    static_assert(std::is_same_v<std::invoke_result_t<GetIoContext>, boost::asio::io_context&>);

public:
    GetDomain(ConfigPtr config,
              cache::CachePtr cache,
              db::MetaPoolPtr metaPool,
              db::PeersPoolPtr peersPool,
              db::MetaAdaptorFactoryPtr metaAdaptorFactory,
              GetIoContext getIoContext)
        : config(config),
          cache(cache),
          metaPool(metaPool),
          peersPool(peersPool),
          metaAdaptorFactory(metaAdaptorFactory),
          getIoContext_(std::move(getIoContext)) {
    }

private:
    ConfigPtr config;
    cache::CachePtr cache;
    db::MetaPoolPtr metaPool;
    db::PeersPoolPtr peersPool;
    db::MetaAdaptorFactoryPtr metaAdaptorFactory;
    GetIoContext getIoContext_;

    ymod_webserver::methods::http_method method() const override final {
        return ymod_webserver::methods::mth_get;
    }

    void execute(RequestContext& context) const override final {
        using services::blackbox::BlackboxImpl;
        boost::asio::spawn(
            getIoContext_(),
            GetDomainPerformer(
                context,
                config,
                db::coro::BaseMetaAdaptor(metaAdaptorFactory->getBaseMetaAdaptor(
                    config->meta.db.adaptor, metaPool, context.scribe)),
                db::BasePeersAdaptor(config->peers.adaptor, context.scribe, peersPool),
                cache,
                std::make_shared<BlackboxImpl>(
                    config->blackbox, services::getHttpClient(config->blackbox.http.module))),
            boost::coroutines::attributes(config->coroutineStackSize));
    }
};

} // namespace sharpei::server::handlers
