#ifndef SHARPEI_SERVER_HANDLERS_PING_H
#define SHARPEI_SERVER_HANDLERS_PING_H

#include <internal/server/handlers/base.h>

namespace sharpei {
namespace server {
namespace handlers {

class Ping : public Base {
private:
    ymod_webserver::methods::http_method method() const override final {
        return ymod_webserver::methods::mth_get;
    }

    void execute(RequestContext& req) const override final {
        Response(*req.response).ok(fixed_size(format::text("pong")));
    }
};

} // namespace handlers
} // namespace server
} // namespace sharpei

#endif // SHARPEI_SERVER_HANDLERS_PING_H
