#pragma once

#include <internal/db/adaptors/meta_adaptor.h>
#include <internal/db/adaptors/meta_adaptor_factory.h>
#include <internal/server/handlers/base.h>

namespace sharpei {
namespace server {
namespace handlers {

class Pingdb : public Base {
public:
    Pingdb(ConfigPtr config, db::MetaPoolPtr metaPool, db::MetaAdaptorFactoryPtr metaAdaptorFactory)
        : config(config), metaPool(metaPool), metaAdaptorFactory(metaAdaptorFactory) {
    }

private:
    ConfigPtr config;
    db::MetaPoolPtr metaPool;
    db::MetaAdaptorFactoryPtr metaAdaptorFactory;

    ymod_webserver::methods::http_method method() const override final {
        return ymod_webserver::methods::mth_get;
    }

    void execute(RequestContext& req) const override final {
        using namespace ymod_webserver::helpers;
        using namespace ymod_webserver::helpers::transfer_encoding;
        metaAdaptorFactory->getBaseMetaAdaptor(config->meta.db.adaptor, metaPool, req.scribe)
            ->ping([=] { Response(*req.response).ok(fixed_size(format::text("pong"))); },
                   [=](const ExplainedError& error) mutable {
                       const auto message = error.full_message();
                       Response(*req.response)
                           .internal_server_error(fixed_size(format::text(message)));
                   });
    }
};

} // namespace handlers
} // namespace server
} // namespace sharpei
