#pragma once

#include <internal/reflection/shard.h>
#include <internal/server/handlers/base.h>
#include <mail/sharpei/include/internal/db/filtration_strategy.h>
#include <mail/sharpei/include/internal/poller/meta_shards_provider.h>

namespace sharpei::server::handlers {

class SharddbStat : public Base {
public:
    SharddbStat(cache::CachePtr cache, ConfigPtr config)
        : cache(std::move(cache)), config(std::move(config))
    {}

private:
    cache::CachePtr cache;
    ConfigPtr config;

    ymod_webserver::methods::http_method method() const final {
        return ymod_webserver::methods::mth_get;
    }

    void execute(RequestContext& req) const final {
        constexpr Shard::Id shardId = poller::MetaShardsProvider::shardId;

        ExplainedError error;
        boost::optional<Shard> shard;
        std::tie(error, shard) = cache->getShard(shardId);

        if (!error && !shard.is_initialized()) {
            error = ExplainedError(Error::internalError, "return code is ok but the list of databases is empty");
        }
        if (error) {
            Response(*req.response).internal_server_error(fixed_size(format::json(error)));
            return;
        }

        Response(*req.response).ok(chunked(format::json(shard->databases)));
    }
};

}
