#pragma once

#include <internal/reflection/shard.h>
#include <internal/server/handlers/base.h>

namespace sharpei {
namespace server {
namespace handlers {

class Stat : public Base {
public:
    Stat(cache::CachePtr cache)
        : cache(cache)
    {}

private:
    cache::CachePtr cache;

    ymod_webserver::methods::http_method method() const override final {
        return ymod_webserver::methods::mth_get;
    }

    void execute(RequestContext& req) const override final {
        using yamail::data::serialization::writeJson;
        using cache::Availability;
        auto shardsInfo = makeShardsInfoOldFormat(*cache, &Availability::smooth);
        auto orderedShardsInfo = reflection::makeShardsInfoOldFormat(shardsInfo);
        Response(*req.response).ok(chunked(format::json(orderedShardsInfo)));
    }
};

namespace tags {

struct Nice {};
struct Strict {};

} // namespace tags

template <class ShardT, class Tag = tags::Nice>
class StatNew : public Base {
public:
    StatNew(cache::CachePtr cache)
        : cache(cache)
    {}

private:
    cache::CachePtr cache;

    ymod_webserver::methods::http_method method() const override final {
        return ymod_webserver::methods::mth_get;
    }

    void execute(RequestContext& req) const override final {
        const auto shardId = req.getOptionalArg<Shard::Id>("shard_id");
        selectShards(*cache, shardId)
            .bind([&](const auto& shards) {
                const auto shardsInfo = makeShardsInfoNewFormat(shards, *cache, &cache::Availability::smooth);
                if constexpr (std::is_same_v<Tag, tags::Strict>) {
                    if (shardsInfo.empty()) {
                        const ExplainedError error(Error::internalError, "shards info is not available yet");
                        Response(*req.response).internal_server_error(fixed_size(format::json(error)));
                        return;
                    }
                }
                auto orderedShardsInfo = reflection::makeShardsInfoNewFormat<ShardT>(shardsInfo);
                Response(*req.response).ok(chunked(format::json(orderedShardsInfo)));
            })
            .catch_error([&](const auto error) {
                if (error != Error::shardNotFound) {
                    throw std::logic_error("unexpected error condition");
                }
                Response(*req.response).not_found(fixed_size(format::json(error.full_message())));
            });
    }
};

} // namespace handlers
} // namespace server
} // namespace sharpei
