#pragma once

#include <internal/expected.h>
#include <internal/domain.h>
#include <internal/task_context.h>

namespace sharpei::services::blackbox {

struct HostedDomain {
    std::int64_t domid;
};

struct Blackbox {
    virtual ~Blackbox() = default;

    virtual expected<std::vector<HostedDomain>> getHostedDomains(DomainId domainId,
            const TaskContextPtr& context) const = 0;

    virtual expected<std::vector<HostedDomain>> getHostedDomains(const std::string& domain,
            const TaskContextPtr& context) const = 0;
};

using BlackboxPtr = std::shared_ptr<const Blackbox>;

} // namespace sharpei::services::blackbox
