#pragma once

#include <internal/expected.h>
#include <internal/task_context.h>

#include <boost/serialization/strong_typedef.hpp>

namespace sharpei::services::iam {

BOOST_STRONG_TYPEDEF(std::string, IamToken);

struct Iam {
    virtual ~Iam() = default;

    virtual expected<IamToken> getIamToken(const TaskContextPtr& context) const = 0;
};

using IamPtr = std::shared_ptr<const Iam>;

} // namespace sharpei::services::iam
