#pragma once

#include <internal/services/iam/iam.h>
#include <internal/services/iam/iam_config.h>
#include <internal/services/iam/json_web_token_generator.h>

#include <ymod_httpclient/call.h>

namespace sharpei::services::iam {

class IamClient final : public Iam {
public:
    IamClient(const IamClientConfig& config, std::shared_ptr<ymod_httpclient::cluster_call> httpClient,
            JsonWebTokenGeneratorPtr jwtGenerator)
            : config(config), httpClient(httpClient), jwtGenerator(jwtGenerator) {}

    expected<IamToken> getIamToken(const TaskContextPtr& context) const override;

private:
    IamClientConfig config;
    std::shared_ptr<ymod_httpclient::cluster_call> httpClient;
    JsonWebTokenGeneratorPtr jwtGenerator;

    expected<IamToken> getIamToken(const TaskContextPtr& context, std::string_view jwt) const;
};

} // namespace sharpei::services::iam
